/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.Severity;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.HttpProxySettings;
import oracle.install.ivw.common.bean.MyOracleSupportSettings;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesCheckEvent;
import oracle.install.ivw.common.util.autoupdates.UpdatesCheckListener;
import oracle.install.ivw.common.view.ProxySettingsDialog;
import oracle.install.library.util.GenericValidation;

public class AutoUpdatesOptionsPane
extends JPanel
implements UpdatesCheckListener {
    private MultilineLabel lblSoftwareUpdatesPrompt = null;
    private JRadioButton rdoMyOracleSupportDet = null;
    private MultilineLabel lblMyOracleSupportDet = null;
    private JRadioButton rdoOffLineMode = null;
    private JRadioButton rdoSkipUpdates = null;
    private JLabel lblFileLocation;
    private JTextField txtFileLocation;
    private JButton btnBrowse;
    private JLabel lblMyOracleSupportUserName;
    private JLabel lblMyOracleSupportPassword;
    private JTextField txtUserId;
    private JPasswordField txtPassword;
    private JButton btnProxySettings;
    private JButton btnTestConnection;
    private HttpProxySettings httpProxySettings;
    private Resource resource;
    private MultilineLabel lblOfflineMode = new MultilineLabel();
    private TogglePane paneOfflineMode;
    private TogglePane paneMOSDetails;
    private static Logger logger = Logger.getLogger(AutoUpdatesOptionsPane.class.getName());

    public AutoUpdatesOptionsPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
        this.buildUI();
    }

    public void setHideOfflineAndSkipOptions(boolean val) {
        if (this.rdoOffLineMode != null && this.rdoSkipUpdates != null && this.paneOfflineMode != null && this.rdoMyOracleSupportDet != null) {
            this.rdoOffLineMode.setVisible(false);
            this.paneOfflineMode.setVisible(false);
            this.rdoSkipUpdates.setVisible(false);
            this.rdoMyOracleSupportDet.setVisible(false);
        }
    }

    public void setPromptMessage(String text) {
        if (this.lblSoftwareUpdatesPrompt != null) {
            this.lblSoftwareUpdatesPrompt.setText(text);
        }
    }

    public void update(UpdatesCheckEvent e) {
        if (e.getType() == UpdatesCheckEvent.Type.NOUPDATES_FOUND) {
            OracleInstaller installer;
            Application application = Application.getInstance();
            boolean standAloneDwld = false;
            if (application instanceof OracleInstaller && (installer = (OracleInstaller)Application.getInstance()).getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE) {
                standAloneDwld = true;
            }
            String noUpdatesMsg = this.resource.getString("NOUPDATES_FOUND", "No updates are available now.", new Object[0]);
            if (standAloneDwld) {
                noUpdatesMsg = this.resource.getString("NOUPDATES_FOUND_STANDALONE", "No updates are available now. Click OK to close the session.", new Object[0]);
            }
            StandardDialog.showInformation((Component)this, (String)noUpdatesMsg);
        }
    }

    public void setAutoUpdateSettings(AutoUpdatesInstallSettings settings) {
        if (settings != null) {
            if (settings.getDownloadType() != null) {
                this.setDownloadType(settings.getDownloadType());
                if (settings.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES && settings.getPatchDownloadLocation() != null) {
                    this.setPatchDownloadLocation(settings.getPatchDownloadLocation());
                }
            }
            MyOracleSupportSettings myOracleSupportSettings = settings.getMyoracleSupportDetails();
            this.setMyOracleSupportDetails(myOracleSupportSettings);
            HttpProxySettings proxySettings = settings.getHttpProxySettings();
            if (proxySettings != null) {
                String host = proxySettings.getHttpProxyHost();
                String password = proxySettings.getHttpProxyPassword();
                int port = proxySettings.getHttpProxyPort();
                String userId = proxySettings.getHttpProxyUserId();
                String realm = proxySettings.getHttpProxyRealm();
                if (proxySettings != null && !GenericValidation.isEmpty(host) || !GenericValidation.isEmpty(password) || !GenericValidation.isEmpty(userId) || port != 0 || !GenericValidation.isEmpty(realm)) {
                    this.httpProxySettings = proxySettings;
                }
            }
        }
    }

    public void setDownloadType(PatchDownloadType type) {
        switch (type) {
            case MYORACLESUPPORT_DOWNLOAD: {
                this.rdoMyOracleSupportDet.setSelected(true);
                break;
            }
            case OFFLINE_UPDATES: {
                this.rdoOffLineMode.setSelected(true);
                break;
            }
            case SKIP_UPDATES: {
                this.rdoSkipUpdates.setSelected(true);
            }
        }
    }

    public PatchDownloadType getDownloadType() {
        if (this.rdoMyOracleSupportDet.isSelected()) {
            return PatchDownloadType.MYORACLESUPPORT_DOWNLOAD;
        }
        if (this.rdoOffLineMode.isSelected()) {
            return PatchDownloadType.OFFLINE_UPDATES;
        }
        return PatchDownloadType.SKIP_UPDATES;
    }

    public HttpProxySettings getHttpProxySettings() {
        return this.httpProxySettings;
    }

    public void buildUI() {
        this.lblSoftwareUpdatesPrompt = new MultilineLabel();
        this.lblMyOracleSupportDet = new MultilineLabel();
        this.rdoMyOracleSupportDet = new JRadioButton();
        this.rdoMyOracleSupportDet.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AutoUpdatesOptionsPane.this.rdoMyOracleSupportDet.isSelected()) {
                    AutoUpdatesOptionsPane.this.setDownloadType(PatchDownloadType.MYORACLESUPPORT_DOWNLOAD);
                }
            }
        });
        this.rdoOffLineMode = new JRadioButton();
        this.rdoOffLineMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AutoUpdatesOptionsPane.this.rdoOffLineMode.isSelected()) {
                    AutoUpdatesOptionsPane.this.setDownloadType(PatchDownloadType.OFFLINE_UPDATES);
                }
            }
        });
        this.rdoSkipUpdates = new JRadioButton();
        this.rdoSkipUpdates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AutoUpdatesOptionsPane.this.rdoSkipUpdates.isSelected()) {
                    AutoUpdatesOptionsPane.this.setDownloadType(PatchDownloadType.SKIP_UPDATES);
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoMyOracleSupportDet);
        group.add(this.rdoOffLineMode);
        group.add(this.rdoSkipUpdates);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblSoftwareUpdatesPrompt, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)0.0);
        this.paneMOSDetails = new TogglePane((JToggleButton)this.rdoMyOracleSupportDet, (Component)this.getPnlMyOracleSupport());
        this.paneMOSDetails.setContentDisabledOnDeselect(true);
        JPanel c = this.getStageLocationPanel();
        SwingUtils.setComponentEnabled((Component)c, (boolean)false);
        this.paneOfflineMode = new TogglePane((JToggleButton)this.rdoOffLineMode, (Component)c);
        this.paneOfflineMode.setContentDisabledOnDeselect(true);
        LayoutUtils.addComponent((Component)this.paneMOSDetails, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.paneOfflineMode, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.rdoSkipUpdates, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)4, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.btnTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyOracleSupportSettings details = AutoUpdatesOptionsPane.this.getMyOracleSupportDetails();
                        HttpProxySettings proxyDetails = AutoUpdatesOptionsPane.this.getHttpProxySettings();
                        AutoUpdatesOptionsPane.this.doTestConnection(details, proxyDetails);
                    }
                });
            }
        });
        this.rdoMyOracleSupportDet.setSelected(true);
        ActiveHelpManager.registerComponent((JComponent)this.rdoMyOracleSupportDet, (String)"AutoUpdatesOptionsPane.rdoMyOracleSupport");
        ActiveHelpManager.registerComponent((JComponent)this.rdoOffLineMode, (String)"AutoUpdatesOptionsPane.rdoOffline");
        ActiveHelpManager.registerComponent((JComponent)this.rdoSkipUpdates, (String)"AutoUpdatesOptionsPane.rdoSkipUpdates");
        ActiveHelpManager.registerComponent((JComponent)this.txtUserId, (String)"AutoUpdatesOptionsPane.txtMOSUserName");
        ActiveHelpManager.registerComponent((JComponent)this.txtPassword, (String)"AutoUpdatesOptionsPane.txtMOSPassword");
        ActiveHelpManager.registerComponent((JComponent)this.txtFileLocation, (String)"AutoUpdatesOptionsPane.txtDownloadLocation");
        this.localize();
        UpdateManager updateMngr = UpdateManager.getInstance();
        updateMngr.addUpdatesCheckListener(this);
    }

    public void localize() {
        String text = this.resource.getString("AUTOUPDATES_PROMPT", "Download software updates for this installation. Software updates consist of recommended updates to the installer system requirement checks, PatchSet Updates (PSUs), and other recommended patches.\n\nSelect one of the following options:", new Object[0]);
        this.lblSoftwareUpdatesPrompt.setText(text);
        text = this.resource.getString("MYORACLESUPPORT_DET", "If you want the installer to connect to Oracle MyOracleSupport and automatically download the software updates that are applicable, then specify the user name and password that can be used for accessing the MyOracleSupport. To test the credentials, click \"Test MyOracleSupport Connection\"", new Object[0]);
        this.lblMyOracleSupportDet.setText(text);
        text = this.resource.getString("MYORACLESUPPORT_PROMPT", "Download using &My Oracle Support Credentials", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoMyOracleSupportDet, (String)text);
        text = this.resource.getString("OFFLINEMODE_PROMPT", "Use pre-&downloaded software updates", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoOffLineMode, (String)text);
        text = this.resource.getString("SKIPUPDATES_PROMPT", "&Skip software updates", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoSkipUpdates, (String)text);
        text = this.resource.getString("MYORACLESUPPORT_USERNAME", "My Oracle Support &user name:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblMyOracleSupportUserName, (String)text);
        this.lblMyOracleSupportUserName.setLabelFor(this.txtUserId);
        text = this.resource.getString("MYORACLESUPPORT_PASSWORD", "My Oracle Support user p&assword:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblMyOracleSupportPassword, (String)text);
        this.lblMyOracleSupportPassword.setLabelFor(this.txtPassword);
        text = this.resource.getString("PROXY_SETTINGS", "&Proxy Settings...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnProxySettings, (String)text);
        text = this.resource.getString("TEST_MYORACLESUPPORT_CONNECTION", "&Test Connection", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnTestConnection, (String)text);
        this.lblOfflineMode.setText(this.resource.getString("OFFLINEMODE_DET", "If software updates are already downloaded and available on your local system then specify the path to the directory where these patches are available.", new Object[0]));
        text = this.resource.getString("OFFLINEMODE_BROWSE", "B&rowse...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowse, (String)text);
        text = this.resource.getString("OFFLINEMODE_LOCATION", "&Location:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblFileLocation, (String)text);
        this.lblFileLocation.setLabelFor(this.txtFileLocation);
    }

    private void doTestConnection(final MyOracleSupportSettings details, final HttpProxySettings p) {
        if (details != null) {
            MyOracleSupportConnect t = new MyOracleSupportConnect(){

                @Override
                public boolean perform(UpdateManager updateManager) throws AutoUpdatesManagerException {
                    boolean connected = false;
                    if (details == null || details.getUserId() == null || details.getUserId().length() == 0) {
                        throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_USERNAME_EMPTY, new Object[0]);
                    }
                    if (details.getPassword() == null || details.getPassword().length() == 0) {
                        throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_PASSWORD_EMPTY, new Object[0]);
                    }
                    connected = updateManager.getConnection(details, p);
                    return connected;
                }
            };
            t.start();
        }
    }

    public MyOracleSupportSettings getMyOracleSupportDetails() {
        String password;
        MyOracleSupportSettings details = new MyOracleSupportSettings();
        if (this.txtUserId.getText() != null && this.txtUserId.getText().length() > 0) {
            details.setUserId(this.txtUserId.getText());
        }
        if (this.txtPassword.getPassword() != null && (password = new String(this.txtPassword.getPassword())).length() > 0) {
            details.setPassword(password);
        }
        return details;
    }

    public void setMyOracleSupportDetails(MyOracleSupportSettings settings) {
        if (settings != null) {
            if (settings.getUserId() != null && settings.getUserId().length() > 0) {
                this.txtUserId.setText(settings.getUserId());
            }
            if (settings.getPassword() != null && settings.getPassword().length() > 0) {
                this.txtPassword.setText(settings.getPassword());
            }
        }
    }

    public void setPatchDownloadLocation(String loc) {
        if (loc != null && loc.length() > 0) {
            this.txtFileLocation.setText(loc);
        }
    }

    public String getPatchDownloadLocation() {
        String location = null;
        if (this.txtFileLocation.getText() != null && this.txtFileLocation.getText().length() > 0) {
            location = this.txtFileLocation.getText();
        }
        return location;
    }

    public JPanel getPnlMyOracleSupport() {
        JPanel pnlMyOracleSupport = new JPanel();
        pnlMyOracleSupport.setLayout(new GridBagLayout());
        this.lblMyOracleSupportUserName = new JLabel();
        this.lblMyOracleSupportPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.txtUserId = new JTextField();
        this.btnProxySettings = new JButton();
        this.btnTestConnection = new JButton();
        this.btnProxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoUpdatesOptionsPane.this.showProxySettingsDialog();
                    }
                });
            }
        });
        LayoutUtils.addComponent((Component)this.lblMyOracleSupportUserName, (Container)pnlMyOracleSupport, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtUserId, (Container)pnlMyOracleSupport, (int)1, (int)0, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        LayoutUtils.addComponent((Component)this.lblMyOracleSupportPassword, (Container)pnlMyOracleSupport, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtPassword, (Container)pnlMyOracleSupport, (int)1, (int)1, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        LayoutUtils.addComponent((Component)this.btnProxySettings, (Container)pnlMyOracleSupport, (int)1, (int)2, (int)1, (int)1, (int)0, (int)22, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 1));
        LayoutUtils.addComponent((Component)this.btnTestConnection, (Container)pnlMyOracleSupport, (int)2, (int)2, (int)1, (int)1, (int)0, (int)22, (double)0.0, (double)0.0, (Insets)new Insets(5, 1, 5, 20));
        return pnlMyOracleSupport;
    }

    public void showProxySettingsDialog() {
        Frame frame = (Frame)SwingUtilities.windowForComponent(this);
        ProxySettingsDialog dialog = new ProxySettingsDialog(frame, this.httpProxySettings);
        this.httpProxySettings = dialog.getProxySettings();
    }

    public JPanel getStageLocationPanel() {
        JPanel stageLocPanel = new JPanel();
        stageLocPanel.setLayout(new GridBagLayout());
        this.lblFileLocation = new JLabel();
        this.txtFileLocation = new JTextField();
        this.btnBrowse = new JButton();
        LayoutUtils.addComponent((Component)this.lblFileLocation, (Container)stageLocPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtFileLocation, (Container)stageLocPanel, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnBrowse, (Container)stageLocPanel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 20));
        final AutoUpdatesOptionsPane rootPanel = this;
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                JFileChooser filechooser = new JFileChooser();
                filechooser.setFileSelectionMode(1);
                String title = AutoUpdatesOptionsPane.this.resource.getString("OFFLINEMODE_BROWSE_PROMPT1", "Select Location", new Object[0]);
                String btnText = AutoUpdatesOptionsPane.this.resource.getString("OFFLINEMODE_BROWSE_PROMPT2", "Select", new Object[0]);
                filechooser.setDialogTitle(title);
                filechooser.setApproveButtonText(btnText);
                if (AutoUpdatesOptionsPane.this.txtFileLocation.getText() != null && !AutoUpdatesOptionsPane.this.txtFileLocation.getText().equals("")) {
                    filechooser.setCurrentDirectory(new File(AutoUpdatesOptionsPane.this.txtFileLocation.getText()));
                }
                if ((returnVal = filechooser.showOpenDialog(rootPanel)) == 0) {
                    AutoUpdatesOptionsPane.this.txtFileLocation.setText(filechooser.getSelectedFile().getPath());
                }
            }
        });
        return stageLocPanel;
    }

    abstract class MyOracleSupportConnect
    extends Thread {
        public MyOracleSupportConnect() {
            super("AutoUpdatesOptionsPane.MyOracleSupportConnect");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UpdateManager updateManager = UpdateManager.getInstance();
            try {
                String msg = AutoUpdatesOptionsPane.this.resource.getString("MYORACLESUPPORTCONN_TESTING", "Testing the connection to My Oracle Support. This may take several minutes depending on your connection. Please wait...", new Object[0]);
                Application.showStatus((String)msg);
                boolean connected = this.perform(updateManager);
                if (connected) {
                    String message = AutoUpdatesOptionsPane.this.resource.getString("MYORACLESUPPORTCONN_SUCCESS", "Test connection to My Oracle Support succeeded.", new Object[0]);
                    DefaultStatusMessage statusMessage = new DefaultStatusMessage(Level.INFO, message);
                    Application.hideStatus();
                    StandardDialog.showInformation((Component)AutoUpdatesOptionsPane.this, (String)statusMessage.getMessage());
                } else {
                    String error = AutoUpdatesOptionsPane.this.resource.getString("MYORACLESUPPORTCONN_FAILURE", "Test connection to My Oracle Support failed. Check the user name and password.", new Object[0]);
                    Application.hideStatus();
                    DefaultErrorMessage errorMessage = new DefaultErrorMessage(error, Severity.FATAL);
                    StandardDialog.showError((Component)AutoUpdatesOptionsPane.this, (ErrorMessage)errorMessage);
                }
            }
            catch (AutoUpdatesManagerException e) {
                StandardDialog.showError((Component)AutoUpdatesOptionsPane.this, (Throwable)((Object)e));
            }
            finally {
                Application.hideStatus();
            }
        }

        public abstract boolean perform(UpdateManager var1) throws AutoUpdatesManagerException;
    }
}

